#!/usr/bin/env python
#coding=utf-8

class Special:
	def __init__(self):
		self.LNBName1='Lnb1'
		self.LNBName2='Lnb2'
		self.LNBIndex=[5150,5700,5750,9750,10000,10600,10700,10750,11250,11300]
		self.SatID='SatId'
		self.TPID='TpId'
		self.TPNum='TpNum'
		self.TPStartPos='TpStartPos'
		self.TPFre='Frequency'
		self.TPPolar='Polar'
		self.TPSym='Symbol'
		self.UserID='id'
		self.UserProgPos='pos'
		self.UserSatNamePos=18
		self.UserProgNamePos=36

#/********************************** DefaultDB Struct *************************************/
class DefaultSat:
	def __init__(self):
		#/*20B*/              #length   No.  HideShow
		self.SatName =            [16*8, 0, 1]
		self.TunerSelect =        [2,    1, 1]
		self.reserverd =          [30,   2, 0]

		#/*4B*/
		self.Longitude =          [11,   3, 1]
		self.LnbType =            [2,    4, 1]
		self.Lnb1 =               [4,    5, 1]
		self.Lnb2 =               [4,    6, 1]
		self.Diseqc12Pos =        [8,    7, 1]
		self.Sat22k =             [2,    8, 1]
		self.LongitudeDirection = [1,    9, 1]

		#/*4B*/
		self.Diseqc10 =           [3,    10, 1]
		self.Sat12v =             [1,    11, 1]
		self.TpStartPos =         [13,   12, 0]
		self.TpNum =              [13,   13, 0]
		self.DiseqcMotor =        [2,    14, 1]

class DefaultTP:
	def __init__(self):
		self.Frequency = [14, 0, 1]
		self.Polar =     [1,  1, 1]
		self.Symbol =    [16, 2, 1]
		self.Tp22k =     [1,  3, 0]

class DefaultProg:
	def __init__(self):
		#/*4B*/
		self.SatId =        [13, 0, 0]
		self.TpId =         [13, 1, 0]
		self.Reserved =     [4,  2, 0]
		self.AudioFormat =  [2,  3, 1]

		self.FavType =      [4*8,4, 1]

		#/*4B*/
		self.ServiceId =    [16, 5, 1]
		self.CasId =        [13, 6, 1]
		self.FlagAv =       [1,  7, 1]
		self.FlagScramble = [1,  8, 1]
		self.FlagLock =     [1,  9, 1]

		#/*4B*/
		self.VideoPid =     [13, 10, 1]
		self.AudioPid =     [13, 11, 1]
		self.VideoType =    [3,  12, 1]
		self.AudioType =    [3,  13, 1]

		#/*4B*/
		self.PmtPid =       [13, 14, 1]
		self.PcrPid =       [13, 15, 1]
		self.FlagHide =     [1,  16, 1]
		self.FlagSkip =     [1,  17, 1]
		self.TunerSelect =  [2,  18, 1]
		self.Reserved2 =    [2,  19, 0]

		self.ProgName =     [24*8,20, 1]




#/************************************ UserDB Struct ************************************/
#//all of the enum variable must be replaced by 1*8

class GxBusPmSatUnicable_s:
	def __init__(self):
		#/*4*4B */
		self.centre_fre =       [16*8,19]

		#/*4B */
		self.if_channel =       [2*8, 20]
		self.lnb_fre_index =    [1*8, 21]
		self.sat_pos =          [1*8, 22]

class GxBusPmSat_s:
	def __init__(self):
		#/*4B */
		self.Lnb1 =             [2*8, 6]
		self.Lnb2 =             [2*8, 7]

		#/*4B */
		self.diseqc11 =         [1*8, 8]
		self.Diseqc12Pos =      [1*8, 9]
		self.diseqc_version =   [1*8, 10]
		self.Diseqc10 =         [1*8, 11]

		#/*4B */
		self.lnb_power =        [4,   12]
		self.Sat22k =           [2,   13]
		self.Sat12v =           [1,   14]
		self.LongitudeDirection = [1, 15]
		self.reserved =         [1*8, 16]
		self.Longitude =        [2*8, 17]

		#/*4*4B */
		self.SatName =          [16*8,18]

		GxBusPmSatUnicable_s.__init__(self)

class UserSat:
	def __init__(self):
		self.id =           [4*8, 0]
		self.tsid =         [2*8, 1]
		self.cur_tv =       [2*8, 2]
		self.cur_radio =    [2*8, 3]
		self.type =         [2*8, 4]
		self.TunerSelect =  [4*8, 5]
		GxBusPmSat_s.__init__(self)

class GxBusPmTp_s:
	def __init__(self):
		self.Symbol =       [4*8, 3]
		self.Polar =        [4*8, 4]#1*8
		self.pls_n =        [4*8, 5]
		self.stream_size =  [4*8, 6]#1*8

class UserTP:
	def __init__(self):
		self.id =           [4*8, 0]
		self.SatId =        [4*8, 1]
		self.Frequency =    [4*8, 2]
		GxBusPmTp_s.__init__(self)

class UserProg:
	def __init__(self):
		#/*4B */
		self.id =           [2*8, 0]
		self.TpId =         [2*8, 1]

		#/*4B */
		self.FlagAv =       [4,   2]
		self.AudioFormat =  [4,   3]
		self.audio_level =  [4,   4]
		self.VideoType =    [4,   5]
		self.sdt_version =  [1*8, 6]
		self.pat_version =  [1*8, 7]

		#/*4B */
		self.SatId =        [2*8, 8]
		self.TunerSelect =  [2*8, 9]

		#/*4B */
		self.ServiceId =    [2*8, 10]
		self.audio_volume = [1*8, 11]
		self.FlagScramble = [1,   12]
		self.FlagSkip =     [1,   13]
		self.FlagLock =     [1,   14]
		self.ttx_flag =     [1,   15]
		self.subt_flag =    [1,   16]
		self.cc_flag =      [1,   17]
		self.ac3_flag =     [1,   18]
		self.definition =   [1,   19]

		#/*4B */
		self.FavType =      [4*8, 20]

		#/*4B */
		self.PcrPid =       [2*8, 21]
		self.PmtPid =       [2*8, 22]

		#/*4B */
		self.bouquet_id =   [2*8, 23]
		self.VideoPid =     [2*8, 24]

		#/*4B */
		self.ecm_pid_v =    [2*8, 25]
		self.pmt_version =  [1*8, 26]
		self.audio_count =  [1*8, 27]

		#/*4B */
		self.ac3_pid =      [2*8, 28]
		self.AudioPid =     [2*8, 29]

		#/*4B*/
		self.cur_audio_ecm_pid = [2*8, 30]
		self.AudioType =    [1*8, 31]
		self.logic_valid =  [1*8, 32]

		#/*4B*/
		self.ts_id =        [2*8, 33]
		self.original_id =  [2*8, 34]

		#/*4B */
		self.CasId =        [4*8, 35]

		#/*5*4B */
		self.ProgName =     [32*8,36]

		#/*4B */
		self.ext_size =     [4*8, 37]

		#/*4B*/
		self.muti_ts_id =   [1*8, 38]
		self.muti_ts_code = [1*8, 39]
		self.muti_ts_exist = [1,  40]
		self.reserved =     [1,   41]
		self.t2mi_exist =   [1,   42]
		self.t2mi_pid =     [13,  43]

		#/*4B*/
		self.data_plp_id =  [1*8, 44]
		self.common_plp_exist = [1*8, 45]
		self.common_plp_id = [1*8, 46]
		self.common_status = [1*8, 47]

		#/*4B*/
		self.major_num =    [2*8, 48]
		self.minor_num =    [2*8, 49]

		#/*4B*/
		self.source_id =    [2*8, 50]
		self.path_select =  [1*8, 51]
		self.out_of_band =  [1*8, 52]

		#/*5*4B */
		self.long_name =    [32*8, 53]

		#/*4B*/
		self.pos =          [4*8,  54]

